#ifndef __BOARD_CFG_H__
#define __BOARD_CFG_H__


/**
  * @brief Configuration of the CRG
  */
/* ʹⲿپ */
#define __HSE_ENABLE                1      /*!< hse_enable                           */

/* ⲿ: 0 Դ, 1 Դ, 2 Զ(ⲿѭ) */
#define __HSE_CLOCK_TYPE            2

/* 趨PLLʱԴƵ: 10MHz IRC10MHz/20MHzⲿ */
#if __HSE_ENABLE == 0
#define DEVICE_OSCSRC_FREQ          (10*1000*1000)
#else
#define DEVICE_OSCSRC_FREQ          (20*1000*1000)
#endif

/* ϵͳʱ 120MHz */
#define DEVICE_SYSCLK_FREQ          (120*1000*1000U)        //DO NOT CHANGE !!!!!!!!!!!!
/* AHBʱӵϵͳʱ */
#define DEVICE_AXICLK_FREQ          (DEVICE_SYSCLK_FREQ)
/* AHBʱӵϵͳʱ */
#define DEVICE_APBCLK_DIV           (4)
/* APBʱƵ MHz */
#define DEVICE_APBCLK_FREQ          (DEVICE_AXICLK_FREQ/DEVICE_APBCLK_DIV)
/* ʱʱƵʵAPBʱƵ */
#define SOC_TIMER_FREQ              (DEVICE_APBCLK_FREQ)

/* Board Pin Configuration */
#define SCIA_TX_PIN                 GPIO_42_SCITXDA
#define SCIA_RX_PIN                 GPIO_43_SCIRXDA
/* The following two pins can be used for raw 0025 part without efuse. */
#define SCIB_TX_PIN                 GPIO_14_SCITXDB
#define SCIB_RX_PIN                 GPIO_15_SCIRXDB

#define LOG_SCI_BASE                SCIA_BASE

#define LOG_SCI_BASE               SCIA_BASE

#define LOG_SCI_BASE                    SCIA_BASE


#define LED1_PIN                    86
#define LED2_PIN                    87

#endif
