/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"
#include "board.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define LED_GPIO_PIN    GPIO_PIN_LED2
#define LED_GPIO_CFG    GPIO_CFG_LED2

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */
volatile uint32_t dspTicks = 0;



/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */
/*
 * @brief  CPUTimer1 ISR
 */
#define LED_GPIO_PIN    GPIO_PIN_LED2
#define LED_GPIO_CFG    GPIO_CFG_LED2
typedef struct {
	int32_t EnablePGOut;
	int32_t PGABSending;
	int32_t PGABDir;
	int32_t PGCState;
	int32_t FuncPferr;
	int32_t PGABResolution;
	float_t numQclkfloat;
	int32_t numQclkint;
	float_t numQclkfra_total;
	float_t numQclkfra;
	float_t numQclkfra_pre;
	int32_t Resol;
	int32_t CLBPeriod;
	int32_t PGABPulseWise;
	uint32_t clkadjMatch1;
	int32_t PGABIncPulse;
	int32_t Cnt_PGCLow;
	int32_t Cnt_PGCHigh;
	int32_t SinglePos;
	int32_t LastPos_Zero;
	int32_t CurPos_Zero;
	int32_t PGCHalfWise;
	int32_t ErrorFlag;
	int32_t CPulseFlag;
	int32_t Motor_speed;
	uint16_t numQclkSenddeduct;
	uint16_t numQclkSendadd;
}PGOutData;

volatile PGOutData HW_PGOutData;
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

volatile uint32_t absolutePositionPrevious = 0;
volatile uint32_t absolutePositionCurrent = 320;
volatile uint32_t absolutePositionNext = 0,ptoDirection=0;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */
/*
 * @brief  CPUTimer1 ISR
 */
volatile uint32_t gpreg_dma[3];

volatile float_t test_float;


/*
 * @brief  CPUTimer1 initialization
 */
void PGOutDeal(void)
{
	uint16 GPREGTemp;

#if OPT_LEVEL==2
	#if PTO_DMA
		//gpreg_dma[0] = 0x2;
		//gpreg_dma[1] = 0x1;
		if(1 == HW_PGOutData.EnablePGOut)
		{
			GPREGTemp = 0x2; //ݼأδ
			gpreg_dma[0]= GPREGTemp;
		}

//		if(HW_PGOutData.PGABSending ==0) {
//			GPREGTemp = 0x0;
//		}
//		else if(HW_PGOutData.PGABDir) {
//			GPREGTemp = 0x01;
//		}
//		else {
			GPREGTemp = 0x05;//0x05;
//		}

//		if(HW_PGOutData.PGCState ==0) {
//			GPREGTemp |= 0x08;
//		}

		gpreg_dma[1] = GPREGTemp;

	#else
		//if(1 == HW_PGOutData.EnablePGOut)
		{


			CLB_setGPREG(CLB1_BASE, 0x2|ptoDirection<<2);  //Load data
			CLB_setGPREG(CLB1_BASE, 0x1|ptoDirection<<2);  // start
		}
	#endif
#endif
}






/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief  main function.
 */
int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;

    Device_init();

    GPIO_setDirectionMode(31, 1);
    pto_initAbs2QEP();

  	__enable_irq();

  	CLB_setGPREG(CLB1_BASE, 0x1);
    while (absolutePositionNext<1048567) {

    	absolutePositionNext+=500;
    	ptoDirection = pto_abs2qep_translatePosition(absolutePositionNext);
    	DELAY_US(8);
    	tickCnt=CLB_getRegister(CLB1_BASE, CLB_O_INTR_TAG_REG);
    	if(tickCnt==1)
    	{CLB_clearInterruptTag(CLB1_BASE);
    	 PGOutDeal();

    	}
    }

    return 0;
}

