/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *   @file     clb_ex08_abs2qe.c
 *   @brief
 *   @details

 * See LICENSE for license details.
 */
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "board.h"
#include "pto_abs2qep.h"
#include "gs32_math.h"
#include "stdlib.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define LED_STA_PIN     GPIO_PIN_LED2

#define PTO_DMA 1
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

typedef struct {
	int32_t EnablePGOut;
	int32_t PGABSending;
	int32_t PGABDir;
	int32_t PGCState;
	int32_t FuncPferr;
	int32_t PGABResolution;
	float_t numQclkfloat;
	int32_t numQclkint;
	float_t numQclkfra_total;
	float_t numQclkfra;
	float_t numQclkfra_pre;
	int32_t Resol;
	int32_t CLBPeriod;
	int32_t PGABPulseWise;
	uint32_t clkadjMatch1;
	int32_t PGABIncPulse;
	int32_t Cnt_PGCLow;
	int32_t Cnt_PGCHigh;
	int32_t SinglePos;
	int32_t LastPos_Zero;
	int32_t CurPos_Zero;
	int32_t PGCHalfWise;
	int32_t ErrorFlag;
	int32_t CPulseFlag;
	int32_t Motor_speed;
	uint16_t numQclkSenddeduct;
	uint16_t numQclkSendadd;
}PGOutData;

volatile PGOutData HW_PGOutData;

//#define EPwm1Regs  (*((struct EPWM_REGS *)EPWM1_BASE))
/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
//
// Globals used by the position sampling ISR
//
volatile uint32_t ptoDirection;
//
// Globals used for testing the absolute position compared to
// the incremental position measured by the eQEP module
//
volatile uint32_t absolutePositionPrevious = 0;
volatile uint32_t absolutePositionCurrent = 320;
volatile uint32_t absolutePositionNext = 0;
/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

volatile uint32_t gpreg_dma[3];

volatile float_t test_float;

void DmaPto(void)
{
	XDMA_initController(DMA1_BASE);
	XDMA_ConfigParams dmaCfg_tx = {0};

	XDMA_stopChannel(DMA1_CH1_BASE);
	dmaCfg_tx.blockTS = 2;
	dmaCfg_tx.dmaDstReqId = DMAMUX_ReqId_Trig_EPWM1xSOCA;
	dmaCfg_tx.enableInterrupt = 0;
	dmaCfg_tx.srcAddr = (Uint32)&gpreg_dma;
	dmaCfg_tx.destAddr = (Uint32)(CLB1_BASE + CLB_LOGICCTL + CLB_O_GP_REG);
	dmaCfg_tx.reloadSrc = true;
	dmaCfg_tx.reloadDst = true;
	dmaCfg_tx.ttfc    = XDMA_TT_FC_1_M2P_DMAC;
	dmaCfg_tx.srcBtl  = XDMA_BTL_4;
	dmaCfg_tx.destBtl = XDMA_BTL_4;
	dmaCfg_tx.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_4;
	dmaCfg_tx.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_4;
	dmaCfg_tx.srcAddrDirect = XDMA_ADDR_INCRE;
	dmaCfg_tx.destAddrDirect = XDMA_ADDR_NO_CHANGE;
	XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg_tx);
	XDMA_startChannel(DMA1_CH1_BASE);
}


void PGOutDeal(void)
{
	uint16 GPREGTemp;

#if OPT_LEVEL ==1
	#if PTO_DMA
	if(1 == HW_PGOutData.EnablePGOut) {
			GPREGTemp = 0x01; //ݼأδ
			gpreg_dma[0]= GPREGTemp;
//			CLB_setGPREG(CLB1_BASE, GPREGTemp);

			GPREGTemp = 0x02;
			if(HW_PGOutData.PGCState ==0) {
				GPREGTemp |= 0x08;
			}
			gpreg_dma[1]= GPREGTemp;
//			CLB_setGPREG(CLB1_BASE, GPREGTemp); //λ

			if(HW_PGOutData.PGABSending ==0) {
				GPREGTemp = 0x0;
			}
			else if(HW_PGOutData.PGABDir) {
				GPREGTemp = 0x05;
			}
			else {
				GPREGTemp = 0x01;
			}
			gpreg_dma[2]= GPREGTemp;
//			CLB_setGPREG(CLB1_BASE, GPREGTemp);//
		}
		else { //һelse֧û
			GPREGTemp = 0x0A;
			gpreg_dma[0]= GPREGTemp;
//			CLB_setGPREG(CLB1_BASE, GPREGTemp);

	//		GPREGTemp = 0x0B; //CLBδ/Ϊ0Bit0Ϊ1ᵼCLB״̬쳣
			GPREGTemp = 0x06;
			gpreg_dma[1]= GPREGTemp;
			gpreg_dma[2]= 0x2;
//			CLB_setGPREG(CLB1_BASE, GPREGTemp);
		}
	#else

		while(CLB_getInterruptTag(CLB1_BASE) !=2)
		{}
		CLB_clearInterruptTag(CLB1_BASE);

		if(1 == HW_PGOutData.EnablePGOut) {
	//		GPREGTemp = 0x0A;
			GPREGTemp = 0x01; //ݼأδ
			CLB_setGPREG(CLB1_BASE, GPREGTemp);

			GPREGTemp = 0x02;
			if(HW_PGOutData.PGCState ==0) {
				GPREGTemp |= 0x08;
			}
			CLB_setGPREG(CLB1_BASE, GPREGTemp); //λ

			if(HW_PGOutData.PGABSending ==0) {
				GPREGTemp = 0x0;
			}
			else if(HW_PGOutData.PGABDir) {
				GPREGTemp = 0x05;
			}
			else {
				GPREGTemp = 0x01;
			}

			CLB_setGPREG(CLB1_BASE, GPREGTemp);//
		}
		else { //һelse֧û
			GPREGTemp = 0x0A;
			CLB_setGPREG(CLB1_BASE, GPREGTemp);

	//		GPREGTemp = 0x0B; //CLBδ/Ϊ0Bit0Ϊ1ᵼCLB״̬쳣
			GPREGTemp = 0x06;
			CLB_setGPREG(CLB1_BASE, GPREGTemp);
		}
	#endif
#elif OPT_LEVEL==2
	#if PTO_DMA
		//gpreg_dma[0] = 0x2;
		//gpreg_dma[1] = 0x1;
		if(1 == HW_PGOutData.EnablePGOut)
		{
			GPREGTemp = 0x2; //ݼأδ
			gpreg_dma[0]= GPREGTemp;
		}

//		if(HW_PGOutData.PGABSending ==0) {
//			GPREGTemp = 0x0;
//		}
//		else if(HW_PGOutData.PGABDir) {
//			GPREGTemp = 0x01;
//		}
//		else {
			GPREGTemp = 0x05;//0x05;
//		}

//		if(HW_PGOutData.PGCState ==0) {
//			GPREGTemp |= 0x08;
//		}

		gpreg_dma[1] = GPREGTemp;

	#else
		if(1 == HW_PGOutData.EnablePGOut)
		{
			CLB_setGPREG(CLB1_BASE, 0x2);  //Load data

			if(HW_PGOutData.PGABSending ==1)
				GPREGTemp = 0x1;
			else
				GPREGTemp = 0x0;

			CLB_setGPREG(CLB1_BASE, GPREGTemp);  // start
		}
	#endif
#endif
}

void PGABCalc(void)
{
	int64 IncPluseTemp;

	#if OPT_LEVEL ==1
		IncPluseTemp = (int64)HW_PGOutData.FuncPferr * HW_PGOutData.PGABResolution *4;

		HW_PGOutData.numQclkfloat = __divf32(IncPluseTemp, HW_PGOutData.Resol);
		HW_PGOutData.PGABPulseWise = (HW_PGOutData.CLBPeriod) / __fabs(HW_PGOutData.numQclkfloat);
		HW_PGOutData.clkadjMatch1 = HW_PGOutData.PGABPulseWise * (1-__fabs(HW_PGOutData.numQclkfloat_total));

	//	if(HW_PGOutData.clkadjMatch1 > 1)
	//		HW_PGOutData.clkadjMatch1 -=1;

		CLB_writeDbgRx(CLB1_BASE, 4, HW_PGOutData.clkadjMatch1);

		HW_PGOutData.numQclkfra_total += __ffract(HW_PGOutData.numQclkfloat);

		if(HW_PGOutData.numQclkfra_total >= 1.0f) {
			HW_PGOutData.numQclkfra_total -= 1;
			HW_PGOutData.numQclkfloat += 1;
		}
		else if(HW_PGOutData.numQclkfra_total <= -1.0f) {
			HW_PGOutData.numQclkfra_total += 1;
			HW_PGOutData.numQclkfloat -= 1;
		}

		if(HW_PGOutData.numQclkfloat > 0) {
			HW_PGOutData.PGABDir = 1;
		}
		else {
			HW_PGOutData.PGABDir = 0;
		}

		HW_PGOutData.PGABIncPulse = __fabs(HW_PGOutData.numQclkfloat);
		HW_PGOutData.PGABSending = 1;
	#elif OPT_LEVEL==2
#endif
		IncPluseTemp = (int64)HW_PGOutData.FuncPferr * HW_PGOutData.PGABResolution *4;
		HW_PGOutData.numQclkfloat = __divf32(IncPluseTemp, HW_PGOutData.Resol);
		HW_PGOutData.numQclkfra = modff(HW_PGOutData.numQclkfloat, &HW_PGOutData.numQclkint);
		HW_PGOutData.numQclkint = (int32_t)HW_PGOutData.numQclkfloat;
//		HW_PGOutData.numQclkfra = HW_PGOutData.numQclkfloat-HW_PGOutData.numQclkint;

		test_float+=HW_PGOutData.numQclkfloat;



		//ʣµС+ڵС
		HW_PGOutData.numQclkfra_total = HW_PGOutData.numQclkfra_pre + HW_PGOutData.numQclkfra;

		if(HW_PGOutData.numQclkfra_total >= 1.0f) {
			HW_PGOutData.numQclkfra_total -= 1;
			HW_PGOutData.numQclkint += 1;
		}
		else if(HW_PGOutData.numQclkfra_total <= -1.0f) {
			HW_PGOutData.numQclkfra_total += 1;
			HW_PGOutData.numQclkint -= 1;
		}

		HW_PGOutData.PGABPulseWise = (HW_PGOutData.CLBPeriod / __fabs(HW_PGOutData.numQclkfloat)); //֮CLBʱ

		//֮CLBʱӵ
		HW_PGOutData.numQclkSenddeduct = (HW_PGOutData.PGABPulseWise+1)*__fabs(HW_PGOutData.numQclkfloat) - HW_PGOutData.CLBPeriod;

		if(__fabs(HW_PGOutData.numQclkint) > HW_PGOutData.numQclkSenddeduct)   //ֹֻһص
	    {
			HW_PGOutData.numQclkSenddeduct+=1; 						//֮CLBʱӵȡ
	    }
		HW_PGOutData.numQclkSendadd =__fabs(HW_PGOutData.numQclkfloat)-HW_PGOutData.numQclkSenddeduct; //֮CLBʱӵ

		HW_PGOutData.clkadjMatch1=HW_PGOutData.PGABPulseWise * __fabs(HW_PGOutData.numQclkfra_pre);  //ʱӵѾеʱӣֱӼص
	    if(HW_PGOutData.clkadjMatch1==(HW_PGOutData.PGABPulseWise-1))
	    {
	    	HW_PGOutData.clkadjMatch1-=2;
	    }
	    //2025.5.30, numQclkfloat=0.25&0.125ʱ
	    else if(HW_PGOutData.clkadjMatch1<(HW_PGOutData.PGABPulseWise-10))
	    {
	    	HW_PGOutData.clkadjMatch1+=5;
	    }

	    HW_PGOutData.numQclkfra_pre =HW_PGOutData.numQclkfra_total;  //ǰʣС

		if(HW_PGOutData.numQclkfloat > 0) {
			HW_PGOutData.PGABDir = 1;
		}
		else {
			HW_PGOutData.PGABDir = 0;
		}
		if(0 == HW_PGOutData.numQclkint)
			HW_PGOutData.PGABSending = 0;
		else
			HW_PGOutData.PGABSending = 1;
//	#endif

}

void PGCCalc(void)
{
	int64 Temp2, Temp3;

	HW_PGOutData.LastPos_Zero = HW_PGOutData.CurPos_Zero;
	if(HW_PGOutData.SinglePos > (HW_PGOutData.Resol >> 1))
		HW_PGOutData.CurPos_Zero = HW_PGOutData.SinglePos - HW_PGOutData.Resol;
	else
		HW_PGOutData.CurPos_Zero = HW_PGOutData.SinglePos;

	if(labs(HW_PGOutData.CurPos_Zero) <= HW_PGOutData.PGCHalfWise)
	{
		if((HW_PGOutData.PGCState == 0) || (HW_PGOutData.PGCState == 2) || (HW_PGOutData.PGCState == 3))
			HW_PGOutData.PGCState = 1;
		else
			HW_PGOutData.PGCState = 4;
	}
	else if(labs(HW_PGOutData.CurPos_Zero) < (HW_PGOutData.Resol >> 2))
	{
		if((HW_PGOutData.PGCState == 1) || (HW_PGOutData.PGCState = 4))
			HW_PGOutData.PGCState = 2;
		else if((HW_PGOutData.CurPos_Zero > HW_PGOutData.PGCHalfWise) &&
				(HW_PGOutData.LastPos_Zero < -HW_PGOutData.PGCHalfWise))
			HW_PGOutData.PGCState = 3;
		else
			HW_PGOutData.PGCState = 0;
	}
	else
	{
		HW_PGOutData.PGCState = 0;
	}

	if(HW_PGOutData.PGCState == 1)
	{
		if(HW_PGOutData.CurPos_Zero > HW_PGOutData.LastPos_Zero)
		{
			Temp2 = -HW_PGOutData.PGCHalfWise - HW_PGOutData.LastPos_Zero;
			Temp2 *= HW_PGOutData.CLBPeriod;
			Temp2 /= (HW_PGOutData.CurPos_Zero - HW_PGOutData.LastPos_Zero);
		}
		else if(HW_PGOutData.CurPos_Zero < HW_PGOutData.LastPos_Zero)
		{
			Temp2 = HW_PGOutData.LastPos_Zero - HW_PGOutData.PGCHalfWise;
			Temp2 *= HW_PGOutData.CLBPeriod;
			Temp2 /= (HW_PGOutData.LastPos_Zero - HW_PGOutData.CurPos_Zero);
		}
		else
		{
			Temp2 = HW_PGOutData.CLBPeriod;
		}

		if((Temp2 >= 0) && (Temp2 <= HW_PGOutData.CLBPeriod))
		{
			HW_PGOutData.Cnt_PGCLow = 0;
			HW_PGOutData.Cnt_PGCHigh = Temp2;
		}
		else
		{
			HW_PGOutData.Cnt_PGCLow = 0x7fffffff;
			HW_PGOutData.Cnt_PGCHigh = 0x7fffffff;
			HW_PGOutData.ErrorFlag |= 0x02;
		}
	}

	if(HW_PGOutData.PGCState == 3)
	{
		if(HW_PGOutData.CurPos_Zero > HW_PGOutData.LastPos_Zero)
		{
			Temp2 = -HW_PGOutData.PGCHalfWise - HW_PGOutData.LastPos_Zero;
			Temp2 *= HW_PGOutData.CLBPeriod;
			Temp2 /= (HW_PGOutData.CurPos_Zero - HW_PGOutData.LastPos_Zero);

			Temp3 = -HW_PGOutData.PGCHalfWise - HW_PGOutData.LastPos_Zero;
			Temp3 *= HW_PGOutData.CLBPeriod;
			Temp3 /= (HW_PGOutData.CurPos_Zero - HW_PGOutData.LastPos_Zero);
		}
		else
		{
			Temp2 = HW_PGOutData.LastPos_Zero - HW_PGOutData.PGCHalfWise;
			Temp2 *= HW_PGOutData.CLBPeriod;
			Temp2 /= (HW_PGOutData.LastPos_Zero - HW_PGOutData.CurPos_Zero);

			Temp3 = HW_PGOutData.LastPos_Zero - HW_PGOutData.PGCHalfWise;
			Temp3 *= HW_PGOutData.CLBPeriod;
			Temp3 /= (HW_PGOutData.LastPos_Zero - HW_PGOutData.CurPos_Zero);
		}

		if((Temp2 >= 0) && (Temp2 <= HW_PGOutData.CLBPeriod))
		{
			HW_PGOutData.Cnt_PGCLow = Temp2;
		}
		else
		{
			HW_PGOutData.Cnt_PGCLow = 0x7fffffff;
			HW_PGOutData.ErrorFlag |= 0x04;
		}

		if((Temp3 >= 0) && (Temp3 <= HW_PGOutData.CLBPeriod))
		{
			HW_PGOutData.Cnt_PGCHigh = Temp3;
		}
		else
		{
			HW_PGOutData.Cnt_PGCHigh = 0x7fffffff;
			HW_PGOutData.ErrorFlag |= 0x04;
		}
	}

	if(HW_PGOutData.PGCState == 0)
	{
		HW_PGOutData.Cnt_PGCLow = 0;
		HW_PGOutData.Cnt_PGCHigh = 0;
	}

	if(HW_PGOutData.PGCState == 4)
	{
		HW_PGOutData.Cnt_PGCLow = 0x7fffffff;
		HW_PGOutData.Cnt_PGCHigh = 0x7fffffff;
	}

	if(HW_PGOutData.PGCState)
		HW_PGOutData.CPulseFlag = 1;
	else
		HW_PGOutData.CPulseFlag = 0;
}
volatile float total_edge[4000], edge_total_float;

volatile int32_t index_array, edge_total_integ;
void PGOutCalc(void)
{
	if(HW_PGOutData.EnablePGOut)
	{
		PGABCalc();
		PGCCalc();
	}
	else
	{
		HW_PGOutData.EnablePGOut = 1;
		HW_PGOutData.PGABSending = 0;

		HW_PGOutData.PGABIncPulse = 0x0;//0x7fffffff;
		HW_PGOutData.PGABPulseWise = 0x7fffffff;
		HW_PGOutData.Cnt_PGCLow = 0xFFFFFFFF;//0;
		HW_PGOutData.Cnt_PGCHigh = 0xffffffff;//0;
		if(HW_PGOutData.SinglePos > (HW_PGOutData.Resol >> 1))
			HW_PGOutData.LastPos_Zero = HW_PGOutData.SinglePos - HW_PGOutData.Resol;
		else
			HW_PGOutData.LastPos_Zero = HW_PGOutData.SinglePos;
	}

#if OPT_LEVEL==1
	CLB_setHLCRegisters(CLB1_BASE, HW_PGOutData.PGABPulseWise, HW_PGOutData.PGABIncPulse+1,
			HW_PGOutData.Cnt_PGCLow, HW_PGOutData.Cnt_PGCHigh);
#elif OPT_LEVEL==2
	CLB_setHLCRegisters(CLB1_BASE, HW_PGOutData.PGABPulseWise, HW_PGOutData.clkadjMatch1,
			HW_PGOutData.Cnt_PGCLow, HW_PGOutData.Cnt_PGCHigh);
	CLB_writeDbgRx(CLB1_BASE ,4 ,HW_PGOutData.PGABPulseWise-1);
	CLB_writeDbgRx(CLB1_BASE ,5 ,HW_PGOutData.numQclkSenddeduct+1);
	CLB_writeDbgRx(CLB1_BASE ,6 ,__fabs(HW_PGOutData.numQclkint)+1);

	total_edge[index_array] = HW_PGOutData.numQclkfloat;
//	total_fra[index_array] = HW_PGOutData.numQclkfra_total;
	index_array++;
	edge_total_float += HW_PGOutData.numQclkfloat;
	edge_total_integ += HW_PGOutData.numQclkint;
#endif
}

volatile uint16_t SinglePos_inc, int_cnt = 0;;
void PGInCalc(void)
{
	HW_PGOutData.FuncPferr += (2*HW_PGOutData.Motor_speed)/4000;
	int_cnt++;

 //   if(HW_PGOutData.FuncPferr > 2*HW_PGOutData.Motor_speed)

	if(int_cnt>=3358)
	{
		uint16_t Single=1;
		 if(HW_PGOutData.FuncPferr > 2*HW_PGOutData.Motor_speed)
		    {

		HW_PGOutData.FuncPferr = 0;
		Interrupt_disable(INT_EPWM1);
		XDMA_stopChannel(DMA1_CH1_BASE);
//		HW_PGOutData.Motor_speed = 0;
	}
	}

	HW_PGOutData.SinglePos += SinglePos_inc;
	HW_PGOutData.PGCHalfWise = HW_PGOutData.Resol / (HW_PGOutData.PGABResolution * 2);

	if(HW_PGOutData.SinglePos > HW_PGOutData.PGABResolution)
		HW_PGOutData.SinglePos = SinglePos_inc;
}

void ParaInit(void)
{
//	HW_PGOutData.CLBPeriod = 12480;
//	HW_PGOutData.Resol = 1<<23; //20 resolution encoder
//	HW_PGOutData.PGABResolution = 10000;//384; //PG prescaler
	HW_PGOutData.Motor_speed = 4000;
	SinglePos_inc = 10;
	HW_PGOutData.FuncPferr=000;

	HW_PGOutData.CLBPeriod = 12495;
	HW_PGOutData.Resol = 1<<20; //20 resolution encoder
	HW_PGOutData.PGABResolution =16384 ;//384; //PG prescaler
}

void pto_EPWM1ISR(void)
{

	#if !PTO_DMA
	//trigger PTO output
	PGOutDeal();
	#endif

    GPIO_togglePin(31);

    absolutePositionCurrent+=500;
    //
    // Start the PTO
    //
    uint32_t incrementalPosition;

  //  pto_abs2qep_runPulseGen(ptoDirection);
//    CLB_setGPREG(CLB1_BASE, 0x6);
//    CLB_setGPREG(CLB1_BASE, 0x1);

    incrementalPosition = EQEP_getPosition(EQEP1_BASE);
    //
    // Test the previous PTO
    //

    absolutePositionPrevious = absolutePositionCurrent;
    //
    // Generate a new absolute position based on the current position
    //
//    absolutePositionNext = pto_generateTestAbsPosition(absolutePositionCurrent);
    absolutePositionNext = absolutePositionCurrent;
    //
    // Process the position and and load the HCL FIFO
    // The first time through, the counters will be
    // loaded.
    //
    PGInCalc();

    PGOutCalc();

//    ptoDirection = pto_abs2qep_translatePosition(absolutePositionNext);

	#if PTO_DMA
    PGOutDeal();
	#endif

    //
    // When the ISR is entered again, the next position will
    // be current.
    //
    // Clear INT flag for this timer
    // Acknowledge interrupt group
    //
    absolutePositionPrevious = absolutePositionNext;
    EPWM_clearEventTriggerInterruptFlag(EPWM1_BASE);
    __DSB();
}

int main(void)
{
    uint32_t oldTicks,dir ;
    uint32_t tickCnt=400;

    Device_init();

    //config 125us interrupt
    pto_configEPWM();

    GPIO_setDirectionMode(31, 1);
    pto_initAbs2QEP();

    ParaInit();

	#if PTO_DMA
    DmaPto();
	#endif

	Interrupt_register(INT_EPWM1, &pto_EPWM1ISR);
	Interrupt_enable(INT_EPWM1);
	__enable_irq();

    while (1) {
//    	  pto_abs2qep_translatePosition(tickCnt);
			DELAY_US(5000);
			tickCnt+=200;

//			CLB_setGPREG(CLB1_BASE, 0x1);
//			CLB_setGPREG(CLB1_BASE, 0x6);
//			CLB_setGPREG(CLB1_BASE, 0x1);
    }

    return 0;
}

