from tkinter import filedialog
import os
import shutil

# 删除所有编译生成的flash,tcm和ram文件
def delFiles(path,projNames,extNames):
    for root, dirs, files in os.walk(path,topdown=False,followlinks=False): 
        for name in files:
            proj = os.path.splitext(name)[0]
            ext = os.path.splitext(name)[1]
            if ext in extNames:
                for projName in projNames:
                    if projName in proj:
                        tgt = os.path.join(root,name)
                        tgt = tgt.replace('\\','/')
                        os.remove(tgt)

# 删除所有指定名称的文件夹
def delDirs(path,dirNames):
    tgtDirs = []
    for root, dirs, files in os.walk(path,topdown=False,followlinks=False): 
        for dirName in dirNames:
            if dirName == 'Flash':
                if '.project' in files and '.cproject' in files:
                    for name in dirs:
                        if name == dirName:
                            tgt = os.path.join(root,name)
                            tgt = tgt.replace('\\','/')
                            tgtDirs.append(tgt)
                            break
            else:
                for name in dirs:
                    if name == dirName:
                        tgt = os.path.join(root,name)
                        tgt = tgt.replace('\\','/')
                        tgtDirs.append(tgt)
                        break
    return tgtDirs

if __name__ == "__main__":
    path = filedialog.askdirectory() # 选择目标文件夹，例如gs32_examples
    tgtDirs = delDirs(path,['Flash','TCM','RAM','ILM','Flash_ILM','Flash1.1','Flash1.2','Flash3.0','RAM1.1','RAM1.2','RAM3.0','CPU1_FLASH','CPU1_RAM','DEBUG','Release','.settings'])
    for dir in tgtDirs:
        if os.path.exists(dir):
            shutil.rmtree(dir)
    